;defines

!controller         =   $00
!irqoffset          =   $02
!dircontroller      =   $04




main: {
    ;set up dma
    
    phk
    plb
    
    
    sep #$20
    rep #$14
            
    lda #$0f
    sta $2100
    
    ldx #$00ef          ;h target for irq
    stx !irqoffset
    stx $4207
    
    .loop:
    
    
    .wailoop:
    bra .wailoop
    
    jmp .loop
}



irq: {
    lda $4211                   ;acknowledge irq
    
    lda #$00                    ;1      cgadd
    sta $2121
    
    lda #%00000010              ;1      transfur mode: write twice
    sta $4300
    
    lda #$22                    ;1      register dest (cgram write)
    sta $4301
    
    ldx !controller             ;2      source addr
    stx $4302
    
    lda #$c0                    ;1      source bank
    sta $4304
    
    ldx #$0060                  ;2      transfur size
    stx $4305
    
    lda #$01                    ;1      enable transfur on dma channel 0
    sta $420b
    
    rti
}


nmi: {
    sei                     ;disable interrupts so irq doesn't interrupt nmi
    
    
    php
    sep #$20
    lda #$91                ;enable controller read (and nmi and irq)
    sta $4200
    waitforread:
    lda $4212
    bit #$01
    bne waitforread
    rep #$20
    
    lda $4218               ;store to wram
    beq +
    sta !dircontroller
    and #$fcff
    sta !controller
    +
    plp
    
    rep #$20
    lda !dircontroller
    bit #$0200
    beq +
    dec !irqoffset
    +
    bit #$0100
    beq ++
    inc !irqoffset
    ++
    
    lda !irqoffset
    cmp #$0118              ;right bound of irq
    bpl +++
    cmp #$0080              ;left bound
    bmi +++
    sta $4207
    +++
    
    sep #$20
    -
    lda $4212               ;wait for end of vblank
    bmi -
    
    rti
}


errhandle: {
    ;
    jmp errhandle
}